/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.xfw.pa.tasks.spi;

import com.ibm.hwmca.fw.attn.Attention;
import com.ibm.hwmca.fw.managed.User;
import com.ibm.hwmca.fw.pa.problem.ProblemManager;
import com.ibm.hwmca.fw.rsf.RemoteSupportFacility;
import com.ibm.hwmca.fw.rsf.RsfManager;
import com.ibm.hwmca.fw.service.system.util.ServiceInterfaces;
import com.ibm.hwmca.fw.service.system.util.ServiceInterfacesException;
import com.ibm.hwmca.fw.task.UserContext;
import com.ibm.hwmca.fw.tasklet.PanelBean;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.util.HexString;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.xfw.pa.attention.CommonProblemAttention;
import com.ibm.hwmca.xfw.pa.problem.CommonProblem;
import com.ibm.hwmca.xfw.pa.problem.CriticalProblem;
import com.ibm.hwmca.xfw.pa.problem.ProblemBeanFactory;
import com.ibm.hwmca.xfw.pa.tasks.XFramePrimaryProblemAnalysisServerTasklet;
import com.ibm.hwmca.xfw.panel.pa.primary.CustomerContactInformationBean;
import com.ibm.hwmca.xfw.panel.pa.primary.DetailsBean;
import com.ibm.hwmca.xfw.panel.pa.primary.ManualCallHomeBean;
import com.ibm.hwmca.xfw.panel.pa.primary.PECEBean;

public class PrimaryProblemAnalysisServerTasklet
extends XFramePrimaryProblemAnalysisServerTasklet {
    private static final String TRACE_MASKT = "XPARDIST";
    private static final String TRACE_MASKF = "XPARDISF";
    private static final String TRACE_MASKD = "XPARDISD";
    private static final boolean UNIT_TEST = true;
    public CommonProblem theProblem = null;

    public void logException(Throwable throwable) {
    }

    public PanelBean getPAPanelBean() throws TaskletException {
        Trace.trace(TRACE_MASKT, "--> getPABean()");
        PanelBean theBean = null;
        this.theProblem = this.getProblem();
        if (this.theProblem == null) {
            Trace.trace(TRACE_MASKD, "got a null problem to work with!!!");
            throw new TaskletException("Problem is null");
        }
        Trace.trace(TRACE_MASKD, "go get the bean");
        try {
            ProblemBeanFactory cbf = (ProblemBeanFactory)ServiceInterfaces.getFactory(this.theProblem, "BeanFactory");
            theBean = cbf.getProblemAnalysisBean(this.theProblem, null, "Local", 1);
        }
        catch (ServiceInterfacesException e) {
            Trace.trace(TRACE_MASKT, "can't resolve bean factory!");
            Trace.trace(TRACE_MASKF, e);
            throw new TaskletException(e);
        }
        Trace.trace(TRACE_MASKD, "the bean is" + theBean);
        Trace.trace(TRACE_MASKT, "<-- getPABean()");
        return theBean;
    }

    public DetailsBean getDetailsBean() throws TaskletException {
        Trace.trace(TRACE_MASKF, "--> getDetailsBean()");
        DetailsBean theBean = null;
        CommonProblem theProblem = this.getProblem();
        if (theProblem == null) {
            Trace.trace(TRACE_MASKD, "got a null problem to work with!!!");
        }
        Trace.trace(TRACE_MASKD, "go get the bean");
        try {
            ProblemBeanFactory cbf = (ProblemBeanFactory)ServiceInterfaces.getFactory(theProblem, "BeanFactory");
            theBean = (DetailsBean)cbf.getDetailsBean(theProblem, null, "Local", 1);
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "got an exception");
            Trace.trace(TRACE_MASKF, e);
            throw new TaskletException(e);
        }
        Trace.trace(TRACE_MASKT, "<-- getDetailsBean()");
        return theBean;
    }

    public CustomerContactInformationBean getCustomerContactInformationBean() {
        this.theProblem = this.getProblem();
        Trace.trace(TRACE_MASKF, "--> getCustomerContactInformationBean()");
        CustomerContactInformationBean theBean = new CustomerContactInformationBean();
        theBean.setCustomerName(this.theProblem.getCustomerContact());
        theBean.setCustomerPhone(this.theProblem.getCustomerPhone());
        theBean.setTransmitionType(new String[]{"ModemChoice"});
        return theBean;
    }

    public ManualCallHomeBean getManualCallHomeBean() throws TaskletException {
        Trace.trace(TRACE_MASKT, "-->PrimaryProblemAnalysisServerTasklet.getManualCallHomeBean()");
        ManualCallHomeBean theBean = null;
        CommonProblem theProblem = this.getProblem();
        if (theProblem == null) {
            Trace.trace(TRACE_MASKD, "got a null problem to work with!!!");
        }
        Trace.trace(TRACE_MASKD, "go get the bean");
        try {
            ProblemBeanFactory cbf = (ProblemBeanFactory)ServiceInterfaces.getFactory(theProblem, "BeanFactory");
            theBean = (ManualCallHomeBean)cbf.getServiceInformationBeanOperator(theProblem, null, "Local", 1);
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "got an exception");
            Trace.trace(TRACE_MASKF, e);
            throw new TaskletException(e);
        }
        Trace.trace(TRACE_MASKT, "<-- PrimaryProblemAnalysisServerTasklet.getManualCallHomeBean()");
        return theBean;
    }

    public PECEBean getPECEBean() throws TaskletException {
        Trace.trace(TRACE_MASKT, "-->PrimaryProblemAnalysisServerTasklet.getPECEBean()");
        PECEBean theBean = null;
        CommonProblem theProblem = this.getProblem();
        if (theProblem == null) {
            Trace.trace(TRACE_MASKD, "got a null problem to work with!!!");
        }
        Trace.trace(TRACE_MASKD, "go get the bean");
        try {
            ProblemBeanFactory cbf = (ProblemBeanFactory)ServiceInterfaces.getFactory(theProblem, "BeanFactory");
            theBean = (PECEBean)cbf.getServiceInformationBeanCE(theProblem, null, "Local", 1);
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "got an exception");
            Trace.trace(TRACE_MASKF, e);
            throw new TaskletException(e);
        }
        Trace.trace(TRACE_MASKT, "<-- PrimaryProblemAnalysisServerTasklet.getPECEBean()");
        return theBean;
    }

    public boolean isAdministrator() {
        boolean mode = false;
        Trace.trace(TRACE_MASKT, "--> PrimaryProblemAnalysisServerTasklet.isAdministrator()");
        UserContext userContext = UserContext.getCurrentUserContext();
        if (User.getUser().hasAuth("base.rolegroup.pedebug")) {
            mode = true;
        }
        if (User.getUser().hasAuth("base.rolegroup.service")) {
            mode = true;
        }
        return mode;
    }

    public boolean isRSFEnabled() {
        Trace.trace(TRACE_MASKT, "--> PrimaryProblemAnalysisServerTasklet.isRSFEnabled()");
        boolean RSFEnabled = false;
        RemoteSupportFacility rsf = RsfManager.getRsfManager().getConsoleRsf();
        if (rsf != null) {
            RSFEnabled = rsf.isCallHomeEnabled();
        }
        Trace.trace(TRACE_MASKD, "RSFEnabled is =" + RSFEnabled);
        return RSFEnabled;
    }

    public void requestService(PanelTaskletRequest request) {
        Trace.trace(TRACE_MASKD, "--> requestService()");
        if (this.theProblem != null) {
            Trace.trace(TRACE_MASKF, "call problem.serviceAuthorized()");
            PanelBean cciBean = (PanelBean)request.getData("theBean");
            if (cciBean != null && cciBean instanceof CustomerContactInformationBean) {
                this.theProblem.setCustomerContact(((CustomerContactInformationBean)cciBean).getCustomerNameEdit());
                this.theProblem.setCustomerPhone(((CustomerContactInformationBean)cciBean).getCustomerPhoneEdit());
                Trace.trace(TRACE_MASKD, "the customer name is" + this.theProblem.getCustomerContact());
                Trace.trace(TRACE_MASKD, "the phone number is" + this.theProblem.getCustomerPhone());
                try {
                    ProblemManager thePM = ProblemManager.getProblemManager();
                    thePM.changed(this.theProblem);
                }
                catch (Exception e) {
                    Trace.trace(TRACE_MASKF, "Got an exception");
                    Trace.trace(TRACE_MASKF, e);
                    String refcode = HexString.toHex((byte)-86) + HexString.toHex((byte)50) + Integer.toHexString(4109);
                    CriticalProblem critProb = new CriticalProblem(refcode.toUpperCase(), "00000000");
                    critProb.postIt();
                }
            }
            this.theProblem.serviceAuthorized();
        } else {
            Trace.trace(TRACE_MASKD, "got a null problem to work with!!!");
        }
        Trace.trace(TRACE_MASKD, "delete the attention");
        Attention.deleteAttention(this.attention.getManagedObjectID(), this.attention.getAttentionID());
        Trace.trace(TRACE_MASKD, "<-- PrimaryProblemAnalysisServerTasklet.requestService()");
    }

    public void noService() {
        Trace.trace(TRACE_MASKF, "--> PrimaryProblemAnalysisServerTasklet.noService()");
        if (this.theProblem != null) {
            Trace.trace(TRACE_MASKF, "call problem.serviceDeclined()");
            this.theProblem.serviceDeclined();
        } else {
            Trace.trace(TRACE_MASKD, "got a null problem to work with!!!");
        }
        Trace.trace(TRACE_MASKD, "delete the attention");
        Attention.deleteAttention(this.attention.getManagedObjectID(), this.attention.getAttentionID());
        Trace.trace(TRACE_MASKF, "<-- PrimaryProblemAnalysisServerTasklet.noService()");
    }

    public void manualCallHomeAcknowledged() {
        Trace.trace(TRACE_MASKD, "--> PrimaryProblemAnalysisServerTasklet.manualCallHomeAcknowledged()");
        if (this.theProblem != null) {
            Trace.trace(TRACE_MASKF, "call problem.serviceManual()");
            this.theProblem.serviceManual();
        } else {
            Trace.trace(TRACE_MASKD, "got a null problem to work with!!!");
        }
        Trace.trace(TRACE_MASKD, "delete the attention");
        Attention.deleteAttention(this.attention.getManagedObjectID(), this.attention.getAttentionID());
        Trace.trace(TRACE_MASKD, "<-- PrimaryProblemAnalysisServerTasklet.manualCallHomeAcknowledged()");
    }

    public void deleteMessage() {
        Trace.trace(TRACE_MASKT, "--> PrimaryProblemAnalysisServerTasklet.deleteMessage()");
        Attention.deleteAttention(this.attention.getManagedObjectID(), this.attention.getAttentionID());
        Trace.trace(TRACE_MASKT, "<-- PrimaryProblemAnalysisServerTasklet.deleteMessage()");
    }

    public CommonProblem getProblem() {
        Trace.trace(TRACE_MASKD, "--> getProblem()");
        CommonProblem theProblem = null;
        if (this.attention instanceof CommonProblemAttention) {
            Trace.trace(TRACE_MASKD, "got a common problem. Get it form the attention");
            theProblem = ((CommonProblemAttention)this.attention).getProblem();
            if (theProblem == null) {
                Trace.trace(TRACE_MASKD, "got a null problem in the attention");
            }
        }
        Trace.trace(TRACE_MASKD, "return problem " + theProblem);
        return theProblem;
    }
}

